/*  Ermittelt die Rahmenarbeitszeit für einen gegebenen Arbeitsplatz.
*/
SELECT tsystem.function__drop_by_regex( 'ksvba__get_shifttimes', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ksvba__get_shifttimes( _ksvba_id int )
RETURNS time[2] AS $$

  DECLARE

      _ksv_record record;
      _shifttimes time[];

  BEGIN

      SELECT k.ks_id,
             k.ks_abt,
             k.ks_ausw,
             ba.ksb_timestart,
             ba.ksb_timeend
        INTO _ksv_record
        FROM ksv k
        JOIN ksvba ba ON k.ks_id = ba.ksb_ks_id
       WHERE ba.ksb_id = _ksvba_id;

      IF ( _ksv_record.ks_id IS null ) THEN
         RAISE EXCEPTION 'ksvba with id % not found', _ksvba_id;
      END IF;

      -- Im Kapazitätsstack-Algorithmus für KKS ...
      IF ( TSystem.Settings__GetBool( 'scheduling.algorithm_is_kapa_stack' ) AND scheduling.ksv__is_top_ksv__by__ks_abt( _ksv_record.ks_abt ) ) THEN
          -- ... ist die Arbeitszeit von 0 bis 24 Uhr.
          _shifttimes := array[ '00:00:00'::time, '24:00:00'::time ];

      -- Für Auswärts-Kostenstellen ...
      ELSIF ( _ksv_record.ks_ausw IS true ) THEN
          -- ... ist die Arbeitszeit von 0 bis 24 Uhr.
          _shifttimes := array[ '00:00:00'::time, '24:00:00'::time ];

      -- Standardmäßig ...
      ELSE
          -- ... entspricht die Arbeitszeit den auf der Kostenstelle eingetragenen Werten.
          _shifttimes := array[ _ksv_record.ksb_timestart, _ksv_record.ksb_timeend ];

      END IF;

      RETURN _shifttimes;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
